 ; Ŀ
 ;   Wblock all blocks within a drawing - that is, write them to the disk  
 ;   independent drawing files.  Optionally overwrite existing drawings.   
 ;   Copyright 1992, 2008 by Rocket Software Ltd.                          
 ;   Find all the ME-262 blueprints hidden in your flow charts.            
 ; 
 (DEFUN C:BLOCKOUT (/ bldir dirnam num anon rewind blnam)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Make a block directory name.                                          
 ; 
  (setq bldir (strcat (getvar "dwgprefix") "wblocks"))
  (setq dirnam bldir)
 ; Ŀ
 ;   If it doesn't exist, make it.  If it does then try variations until   
 ;   you find one that doesn't.                                            
 ; 
  (if (vl-file-directory-p dirnam)
      (progn
           (setq num 0)
           (while (vl-file-directory-p
                                (setq dirnam (strcat bldir "-" (itoa num))))
                  (setq num (1+ num)))))
  (vl-mkdir dirnam)
 ; Ŀ
 ;   While there are definitions in the block tables.                      
 ; 
  (setq anon 0)
  (setq num 0)
  (setq rewind T)
  (while (setq blnam (cdr (assoc 2 (tblnext "block" rewind))))
         (if rewind (setq rewind ()))
         (grtext -2 blnam)
         (if (= (substr blnam 1 1) "*")
             (setq anon (1+ anon))
             (progn
                  (command "wblock" (strcat dirnam "\\" blnam) blnam)
                  (setq num (1+ num)))))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (write-line (strcat "Blocks Wblocked: " (itoa num)))
  (if (> anon 0)
      (write-line (strcat "\n" (itoa anon)
                          " anonymous block" (if (> anon 1) "s" "")
                          " ignored")))
 (princ))